/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	RepositionAxes.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cWorkplane.h"

// Repositions the axis and return the new origin, local axes
HRESULT RepositionAxes(double xTranslation = 0.0, double yTranslation = 0.0, double angle= 0.0,
					   IVector **retval1 = NULL, IDirection **retval2 = NULL, IDirection **retval3 = NULL)
{
	START_METHOD("RepositionAxes")
	HRESULT status = CONV_SUCCESS;

	//	Translate the axes
	IVector *pOrigin = NULL;
	status = TranslateAxes(xTranslation, yTranslation, &pOrigin);
	CHECK_RETURN_STATUS(status)

	// Rotate the Axes
	IDirection *pLocalX = NULL,*pLocalY = NULL;
	status = RotateAxes(angle, &pLocalX, &pLocalY);
	CHECK_RETURN_STATUS(status)

	*retval1 = pOrigin;
	*retval2 = pLocalX;
	*retval3 = pLocalY;

	END_METHOD("RepositionAxes");
}
